<?php
/* --------------------------------------------------------------
 ApiRouteRegistration.php 2021-11-11
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2021 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Api\Application\Bootstrapper;

use Doctrine\DBAL\Connection;
use Gambio\Api\Application\BaseApiV3Action;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Bootstrapper;
use Gambio\Core\Application\Routing\RouteCollector;
use RuntimeException;

/**
 * Class ApiRouteRegistration
 *
 * @package Gambio\Api\Application\Bootstrapper
 */
class ApiRouteRegistration implements Bootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        $application->registerShared(BaseApiV3Action::class)->addArgument(Connection::class);
        
        $routeCollector = $this->getRouteCollector($application);
        $routeCollector->get('/api.php/v3', BaseApiV3Action::class);
        
        $pattern = __DIR__ . '/../../Modules/*/routes.php';
        $files   = glob($pattern);
        
        foreach ($files as $file) {
            /** @noinspection PhpIncludeInspection */
            $registerCallback = require $file;
            if (is_callable($registerCallback)) {
                $registerCallback($routeCollector);
            }
        }
    }
    
    
    /**
     * Returns a slim application instance.
     *
     * @param Application $application
     *
     * @return RouteCollector
     */
    private function getRouteCollector(Application $application): RouteCollector
    {
        if ($application->has(RouteCollector::class) === false) {
            throw new RuntimeException('Route collector needs to be registered to register API routes.');
        }
        
        return $application->get(RouteCollector::class);
    }
}